---
title: Overview · Cloudflare Web Application Firewall (WAF) docs
description: The Cloudflare Web Application Firewall (WAF) provides automatic
  protection from vulnerabilities and the flexibility to create custom rules.
lastUpdated: 2025-09-22T16:52:07.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/waf/
  md: https://developers.cloudflare.com/waf/index.md
---

Get automatic protection from vulnerabilities and the flexibility to create custom rules.

Available on all plans

The Cloudflare Web Application Firewall (Cloudflare WAF) checks incoming web and API requests and filters undesired traffic based on sets of rules called rulesets. The matching engine that powers the WAF rules supports the wirefilter syntax using the [Rules language](https://developers.cloudflare.com/ruleset-engine/rules-language/).

Learn how to [get started](https://developers.cloudflare.com/waf/get-started/).

***

## Features

### Custom rules

Create your own custom rules to protect your website and your APIs from malicious incoming traffic. Use advanced features like [WAF attack score](https://developers.cloudflare.com/waf/detections/attack-score/) and [malicious uploads detection](https://developers.cloudflare.com/waf/detections/malicious-uploads/) in your custom rules.

[Use Custom rules](https://developers.cloudflare.com/waf/custom-rules/)

### Rate limiting rules

Define rate limits for incoming requests matching an expression, and the action to take when those rate limits are reached.

[Use Rate limiting rules](https://developers.cloudflare.com/waf/rate-limiting-rules/)

### Managed rules

Enable the pre-configured managed rulesets to get immediate protection. These rulesets are [regularly updated](https://developers.cloudflare.com/waf/change-log/), offering advanced zero-day vulnerability protections, and you can adjust their behavior.

[Use Managed rules](https://developers.cloudflare.com/waf/managed-rules/)

### Account-level configuration

Enterprise-only paid add-on

Create and deploy rulesets to multiple Enterprise zones.

[Use Account-level configuration](https://developers.cloudflare.com/waf/account/)

### Security Events

Review mitigated requests (rule matches) using an intuitive interface. Tailor your security configurations based on sampled logs.

[Explore Security Events](https://developers.cloudflare.com/waf/analytics/security-events/)

### Security Analytics

Displays information about all incoming HTTP requests, including those not affected by security measures.

[Explore Security Analytics](https://developers.cloudflare.com/waf/analytics/security-analytics/)

***

## Related products

**[DDoS Protection](https://developers.cloudflare.com/ddos-protection/)**

Cloudflare DDoS protection secures websites, applications, and entire networks while ensuring the performance of legitimate traffic is not compromised.

**[Page Shield](https://developers.cloudflare.com/page-shield/)**

Page Shield is a comprehensive client-side security solution to ensure the safety of your website visitors' browser environment.

**[Bots](https://developers.cloudflare.com/bots/)**

Cloudflare bot solutions identify and mitigate automated traffic to protect your domain from bad bots.
