---
title: Block Microsoft Exchange Autodiscover requests · Cloudflare Web
  Application Firewall (WAF) docs
description: In some cases, Microsoft Exchange Autodiscover service requests can
  be "noisy", triggering large numbers of HTTP 404 (Not found) errors.
lastUpdated: 2025-07-09T14:24:57.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/waf/custom-rules/use-cases/block-ms-exchange-autodiscover/
  md: https://developers.cloudflare.com/waf/custom-rules/use-cases/block-ms-exchange-autodiscover/index.md
---

In some cases, Microsoft Exchange Autodiscover service requests can be "noisy", triggering large numbers of `HTTP 404` (`Not found`) errors.

This example custom rule blocks requests for `autodiscover.xml` and `autodiscover.src`:

* **Expression**: `(ends_with(http.request.uri.path, "/autodiscover.xml") or ends_with(http.request.uri.path, "/autodiscover.src"))`
* **Action**: *Block*

Alternatively, customers on a Business or Enterprise plan can use the `matches` [comparison operator](https://developers.cloudflare.com/ruleset-engine/rules-language/operators/#comparison-operators) for the same purpose. For this example, the expression would be the following:

```txt
(http.request.uri.path matches "/autodiscover.(xml|src)$")
```
