---
title: API examples of custom rules with the Skip action · Cloudflare Web
  Application Firewall (WAF) docs
description: Use the Rulesets API to configure custom rules via API.
lastUpdated: 2025-07-10T15:46:55.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/waf/custom-rules/skip/api-examples/
  md: https://developers.cloudflare.com/waf/custom-rules/skip/api-examples/index.md
---

Use the [Rulesets API](https://developers.cloudflare.com/ruleset-engine/rulesets-api/) to configure custom rules via API.

The `skip` action supports different [skip options](https://developers.cloudflare.com/waf/custom-rules/skip/options/), according to the security features or products that you wish to skip.

## Before you continue

This page contains examples of different skip rule scenarios for custom rules. Take the following into account:

* The `$ZONE_ID` value is the [ID of the zone](https://developers.cloudflare.com/fundamentals/account/find-account-and-zone-ids/) where you want to add the rule.

* The `$RULESET_ID` value is the ID of the [entry point ruleset](https://developers.cloudflare.com/ruleset-engine/about/rulesets/#entry-point-ruleset) of the `http_request_firewall_custom` phase. For details on obtaining this ruleset ID, refer to [List and view rulesets](https://developers.cloudflare.com/ruleset-engine/rulesets-api/view/). The API examples in this page add a skip rule to an existing ruleset using the [Create a zone ruleset rule](https://developers.cloudflare.com/api/resources/rulesets/subresources/rules/methods/create/) operation.

  However, the entry point ruleset may not exist yet. In this case, invoke the [Create a zone ruleset](https://developers.cloudflare.com/api/resources/rulesets/methods/create/) operation to create the entry point ruleset with a skip rule. Refer to [Create ruleset](https://developers.cloudflare.com/ruleset-engine/rulesets-api/create/#example---create-a-zone-level-phase-entry-point-ruleset) for an example.

* Although each example only includes one action parameter, you can use several skip options in the same rule by specifying the `ruleset`, `phases`, and `products` action parameters simultaneously.

## Skip the remaining rules in the current ruleset

This example invokes the [Create a zone ruleset rule](https://developers.cloudflare.com/api/resources/rulesets/subresources/rules/methods/create/) operation to add a skip rule to the existing `http_request_firewall_custom` phase entry point ruleset with ID `$RULESET_ID`. The rule will skip all remaining rules in the current ruleset for requests matching the rule expression.

```bash
curl "https://api.cloudflare.com/client/v4/zones/$ZONE_ID/rulesets/$RULESET_ID/rules" \
  --request POST \
  --header "Authorization: Bearer $CLOUDFLARE_API_TOKEN" \
  --json '{
    "action": "skip",
    "action_parameters": {
        "ruleset": "current"
    },
    "expression": "http.request.uri.path contains \"/skip-current-ruleset/\"",
    "description": ""
  }'
```

## Skip a phase

This example invokes the [Create a zone ruleset rule](https://developers.cloudflare.com/api/resources/rulesets/subresources/rules/methods/create/) operation to add a rule to the existing `http_request_firewall_custom` phase entry point ruleset with ID `$RULESET_ID`. The rule will skip the `http_ratelimit` phase for requests matching the rule expression.

```bash
curl "https://api.cloudflare.com/client/v4/zones/$ZONE_ID/rulesets/$RULESET_ID/rules" \
  --request POST \
  --header "Authorization: Bearer $CLOUDFLARE_API_TOKEN" \
  --json '{
    "action": "skip",
    "action_parameters": {
        "phases": [
            "http_ratelimit"
        ]
    },
    "expression": "http.request.uri.path contains \"/skip-phase/\"",
    "description": ""
  }'
```

Refer to [Available skip options](https://developers.cloudflare.com/waf/custom-rules/skip/options/) for the list of phases you can skip.

## Skip a phase and do not log matching requests

This example invokes the [Create a zone ruleset rule](https://developers.cloudflare.com/api/resources/rulesets/subresources/rules/methods/create/) operation to add a rule that:

* Skips the `http_ratelimit` phase
* Disables event logging for the current rule

```bash
curl "https://api.cloudflare.com/client/v4/zones/$ZONE_ID/rulesets/$RULESET_ID/rules" \
  --request POST \
  --header "Authorization: Bearer $CLOUDFLARE_API_TOKEN" \
  --json '{
    "action": "skip",
    "action_parameters": {
        "phases": [
            "http_ratelimit"
        ]
    },
    "logging": {
        "enabled": false
    },
    "expression": "http.request.uri.path contains \"/disable-logging/\"",
    "description": ""
  }'
```

Refer to [Available skip options: Logging](https://developers.cloudflare.com/waf/custom-rules/skip/options/#logging) for more information on disabling logging for requests that match a skip rule.

## Skip security products

This example uses the [Create a zone ruleset rule](https://developers.cloudflare.com/api/resources/rulesets/subresources/rules/methods/create/) operation to add a rule that skips the [Zone Lockdown](https://developers.cloudflare.com/waf/tools/zone-lockdown/) and [User Agent Blocking](https://developers.cloudflare.com/waf/tools/user-agent-blocking/) products for requests matching the rule expression.

```bash
curl "https://api.cloudflare.com/client/v4/zones/$ZONE_ID/rulesets/$RULESET_ID/rules" \
  --request POST \
  --header "Authorization: Bearer $CLOUDFLARE_API_TOKEN" \
  --json '{
    "action": "skip",
    "action_parameters": {
        "products": [
            "zoneLockdown",
            "uaBlock"
        ]
    },
    "expression": "http.request.uri.path contains \"/skip-products/\"",
    "description": ""
  }'
```

Refer to [Available skip options](https://developers.cloudflare.com/waf/custom-rules/skip/options/) for the list of products you can skip.
