---
title: Enable Total TLS · Cloudflare SSL/TLS docs
description: "To enable Total TLS - which issues individual certificates for
  your proxied hostnames - follow these instructions:"
lastUpdated: 2025-10-28T14:13:10.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/ssl/edge-certificates/additional-options/total-tls/enable/
  md: https://developers.cloudflare.com/ssl/edge-certificates/additional-options/total-tls/enable/index.md
---

To enable [Total TLS](https://developers.cloudflare.com/ssl/edge-certificates/additional-options/total-tls/) - which issues individual certificates for your proxied hostnames - follow these instructions:

* Dashboard

  To enable Total TLS in the dashboard:

  1. In the Cloudflare dashboard, go to the **Edge Certificates** page.

     [Go to **Edge Certificates**](https://dash.cloudflare.com/?to=/:account/:zone/ssl-tls/edge-certificates)

  2. For **Total TLS**, switch the toggle to **On** and - if desired - choose an issuing **Certificate Authority**.

* API

  To enable Total TLS with the API, send a [`PATCH`](https://developers.cloudflare.com/api/resources/acm/subresources/total_tls/methods/create/) request with the `enabled` parameter set to your desired setting (`true` or `false`).

  You can also specify a desired certificate authority by adding a value to the `certificate_authority` parameter.

## Aspects to consider

* Total TLS certificates follow the Common Name (CN) restriction of 64 characters ([RFC 5280](https://www.rfc-editor.org/rfc/rfc5280.html)). If you have a hostname that exceeds this length, you can create an [Advanced Certificate](https://developers.cloudflare.com/ssl/edge-certificates/advanced-certificate-manager/manage-certificates/#create-a-certificate) via API to cover it.
