---
title: Onion Routing and Tor support · Cloudflare Network settings docs
description: Improve the Tor user experience by enabling Onion Routing, which
  enables Cloudflare to serve your website’s content directly through the Tor
  network and without requiring exit nodes.
lastUpdated: 2025-03-19T10:19:09.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/network/onion-routing/
  md: https://developers.cloudflare.com/network/onion-routing/index.md
---

Improve the Tor user experience by enabling Onion Routing, which enables Cloudflare to serve your website’s content directly through the Tor network and without requiring exit nodes.

## Availability

| | Free | Pro | Business | Enterprise |
| - | - | - | - | - |
| Availability | Yes | Yes | Yes | Yes |

## How it works

Onion Routing helps improve Tor browsing as follows:

* Tor users no longer access your site via exit nodes, which can sometimes be compromised, and may snoop on user traffic.
* Human Tor users and bots can be distinguished by our Onion services, such that interactive challenges are only served to malicious bot traffic.

[Tor Browser](https://tb-manual.torproject.org/about/) users receive an [alt-svc header](https://httpwg.org/specs/rfc7838.html#alt-svc) as part of the response to the first request to your website. The browser then creates a Tor Circuit to access this website using the `.onion` TLD service provided by this header.

You should note that the visible domain in the user interface remains unchanged, as the host header and the SNI are preserved. However, the underlying connection changes to be routed through Tor, as the [UI denotes on the left of the address bar](https://tb-manual.torproject.org/managing-identities/#managing-identities) with a Tor Circuit. Cloudflare does not provide a certificate for the `.onion` domain provided as part of alt-svc flow, which therefore cannot be accessed via HTTPS.

## Enable Onion Routing

* Dashboard

  To enable **Onion Routing** in the dashboard:

  1. Log in to your [Cloudflare account](https://dash.cloudflare.com), and select your account and domain.
  2. Go to **Network**.
  3. For **Onion Routing**, switch the toggle to **On**.

* API

  To enable **Onion Routing** with the API, send a [`PATCH`](https://developers.cloudflare.com/api/resources/zones/subresources/settings/methods/edit/) request with `opportunistic_onion` as the setting name in the URI path, and the `value` parameter set to `"on"`.
