---
title: DHCP relay · Cloudflare Magic WAN docs
description: DHCP Relay provides a way for DHCP clients to communicate with DHCP
  servers that are not available on the same local subnet/broadcast domain. When
  you enable DHCP Relay, Magic WAN Connector forwards DHCP discover messages to
  a predefined DHCP server, and routes the responses back to the original device
  that sent the discover message.
lastUpdated: 2025-11-04T17:07:51.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/magic-wan/configuration/connector/network-options/dhcp/dhcp-relay/
  md: https://developers.cloudflare.com/magic-wan/configuration/connector/network-options/dhcp/dhcp-relay/index.md
---

DHCP Relay provides a way for DHCP clients to communicate with DHCP servers that are not available on the same local subnet/broadcast domain. When you enable DHCP Relay, Magic WAN Connector forwards DHCP discover messages to a predefined DHCP server, and routes the responses back to the original device that sent the discover message.

```mermaid
	flowchart LR
	accTitle: An example of Connector in DHCP Relay mode
			a(Magic WAN Connector) <--> b(Cloudflare/Magic WAN) <--> c(DHCP server)

			subgraph Site A
			d[LAN 1] <--> a
			e[LAN 2] <--> a
			end

			subgraph Site B
			c
			end
			classDef orange fill:#f48120,color: black
			class a,b,c orange
```

*The above graph shows Magic WAN Connector sending DHCP discover messages to a DHCP server offsite.*

Warning

DHCP relay will not work if your DHCP server is behind a [Cloudflare Tunnel](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/). To enable DHCP relay functionality, use either a Magic WAN tunnel or a CNI connection.

To configure DHCP relay:

* Dashboard

  1. Log in to the [Cloudflare dashboard](https://dash.cloudflare.com/) and select your account.
  2. Go to **Networking** > **Magic WAN** > **Connector on-ramps (beta)**.

  1) Select your Magic WAN Connector > **Edit**.
  2) Select **Network Configuration**.
  3) In **LAN configuration**, select the LAN where you need to configure DHCP relay.
  4) Select **Edit**.
  5) Select **This is a DHCP Relay**.
  6) In **Upstream DHCP server addresses**, enter the IP address of your DHCP server.
  7) (Optional) If you need to add more DHCP server addresses, select **Add upstream DHCP server address** as many times as needed, and enter the new values.

* API

  Note

  You will need your [account ID](https://developers.cloudflare.com/fundamentals/account/find-account-and-zone-ids/) and [API token](https://developers.cloudflare.com/fundamentals/api/get-started/account-owned-tokens/) to use the API.

  Create a [`PUT` request](https://developers.cloudflare.com/api/resources/magic_transit/subresources/sites/subresources/lans/methods/update/) to update the LAN where you want to enable DHCP relay:

  Example:

  Required API token permissions

  At least one of the following [token permissions](https://developers.cloudflare.com/fundamentals/api/reference/permissions/) is required:

  * `Magic WAN Write`
  * `Magic Transit Write`

  ```bash
  curl "https://api.cloudflare.com/client/v4/accounts/$ACCOUNT_ID/magic/sites/$SITE_ID/lans/$LAN_ID" \
    --request PUT \
    --header "Authorization: Bearer $CLOUDFLARE_API_TOKEN" \
    --json '{
      "lan": {
          "static_addressing": {
              "dhcp_relay": {
                  "server_addresses": [
                      "192.0.2.1"
                  ]
              }
          }
      }
    }'
  ```
