---
title: Use Logpush with IDS · Cloudflare Magic Firewall docs
description: "You can use Logpush with Magic Firewall IDS to log detected risks:"
lastUpdated: 2025-07-25T16:42:51.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/magic-firewall/how-to/use-logpush-with-ids/
  md: https://developers.cloudflare.com/magic-firewall/how-to/use-logpush-with-ids/index.md
---

You can use Logpush with Magic Firewall IDS to log detected risks:

1. Consult the [Logpush Destination docs](https://developers.cloudflare.com/logs/logpush/logpush-job/api-configuration/#destination) to learn about what destinations Logpush supports. The documentation will also instruct you on how to correctly format the destination URL for Logpush.

2. Follow the [Manage Lopush with cURL](https://developers.cloudflare.com/logs/logpush/examples/example-logpush-curl/) tutorial to validate your Logpush destination and define a Logpush job.

## Notes on using Logpush with IDS

* Magic IDS is an account-scoped dataset. This means the string `/zone/<ZONE_ID>` in the Cloudflare API URLs in the tutorial should be replaced with `/account/<ACCOUNT_ID>`.

* Consult the [Magic IDS Detection fields doc](https://developers.cloudflare.com/logs/logpush/logpush-job/datasets/account/magic_ids_detections/) to know what fields you want configured for the job.

* When creating the Logpush job, the dataset field should equal `magic_ids_detections`.

* Timestamps by default are unixnano. Consult the [Logpush Options docs](https://developers.cloudflare.com/logs/logpush/logpush-job/api-configuration/#options) to learn what format you can choose that will be compatible with your destination and/or expectations. Note that all options must be added *after* all fields you want from the Logpush job, akin to URL parameters.
