---
title: Filter JSON object · Cloudflare Firewall Rules (deprecated) docs
description: "A JSON response for the Filters API has this structure:"
lastUpdated: 2025-05-06T08:26:18.000Z
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/firewall/api/cf-filters/json-object/
  md: https://developers.cloudflare.com/firewall/api/cf-filters/json-object/index.md
---

## Filter object structure and properties

A JSON response for the [Filters API](https://developers.cloudflare.com/api/resources/filters/methods/list/) has this structure:

```json
{
  "id": "6f58318e7fa2477a23112e8118c66f61",
  "expression": "http.request.uri.path ~ \"^.*/wp-login.php$\" or http.request.uri.path ~ \"^.*/xmlrpc.php$\"",
  "paused": true,
  "description": "WordPress login paths",
  "ref": ""
}
```

The following table summarizes the object properties:

| Property | Description | Constraints |
| - | - | - |
| `id` String | A UUIDv4 identifier generated by Cloudflare. | Unique, read onlyLength: 32 characters |
| `expression` String | A Rules language expression used to evaluate requests. For more information, refer to [Expressions](https://developers.cloudflare.com/ruleset-engine/rules-language/expressions/). | |
| `paused` Boolean | Returns `true` when the filter is not active. Use `ref` to enable/disable the filter. | Default: `false` |
| `description` String | An informative summary of the filter. | Maximum length: 500 characters |
| `ref` String | A short string for tagging filters. | Maximum length: 50 characters |
