---
title: Gateway activity logs · Cloudflare One docs
description: Gateway activity logs show the individual DNS queries, Network
  packets, and HTTP requests inspected by Gateway. You can also download
  encrypted SSH command logs for sessions proxied by Gateway.
lastUpdated: 2025-10-24T20:47:24.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/insights/logs/gateway-logs/
  md: https://developers.cloudflare.com/cloudflare-one/insights/logs/gateway-logs/index.md
---

Private source IP substitution

Gateway logs will only show the public IP address for the **Source IP** field. Private IP addresses are substituted by a public IP address via network address translation (NAT).

Gateway activity logs show the individual DNS queries, Network packets, and HTTP requests inspected by Gateway. You can also download encrypted [SSH command logs](https://developers.cloudflare.com/cloudflare-one/traffic-policies/network-policies/ssh-logging/) for sessions proxied by Gateway.

To view Gateway activity logs, log in to [Zero Trust](https://one.dash.cloudflare.com/) and go to **Logs** > **Gateway**. Select an individual row to investigate the event in more detail.

Enterprise users can generate more detailed logs with [Logpush](https://developers.cloudflare.com/cloudflare-one/insights/logs/logpush/).

## Selective logging

By default, Gateway logs all events, including DNS queries and HTTP requests that are allowed and not a risk. You can choose to disable logs or only log blocked requests. To customize what type of events are recorded, log in to [Zero Trust](https://one.dash.cloudflare.com/) and go to **Settings** > **Network**. Under **Activity Logging**, indicate your DNS, Network, and HTTP log preferences.

These settings will only apply to logs displayed in Zero Trust. Logpush data is unaffected.

## DNS logs

### Explanation of the fields

#### Basic information

| Field | Description |
| - | - |
| **Query name** | Name of the domain that was queried. |
| **Query ID** | UUID of the query assigned by Cloudflare. |
| **Email** | Email address of the user who registered the WARP client where traffic originated from. If a non-identity on-ramp (such as a [proxy endpoint](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/agentless/pac-files/)) or machine-level authentication (such as a [service token](https://developers.cloudflare.com/cloudflare-one/access-controls/service-credentials/service-tokens/)) was used, this value will be `non_identity@<team-domain>.cloudflareaccess.com`. |
| **Action** | The [Action](https://developers.cloudflare.com/cloudflare-one/traffic-policies/dns-policies/#actions) Gateway applied to the query (such as Allow or Block). |
| **Time** | Date and time of the DNS query. |
| **Resolver decision** | The reason why Gateway applied a particular **Action** to the request. Refer to the [list of resolver decisions](#resolver-decisions). |
| **Resolved IPs** | Resolved IP addresses in the response. |
| **CNAMEs** | `CNAME` records in the query. |

#### Configuration information

| Field | Description |
| - | - |
| **DNS location** | [User-configured location](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/agentless/dns/locations/) from where the DNS query was made. |
| **Policy name** | Name of the matched policy. |
| **Policy ID** | ID of the matched policy. |
| **Policy description** | Description of the matched policy. |
| **DoH subdomain** | DoH subdomain of the DNS location. |
| **Protocol** | Protocol that was used to make the DNS query (such as `https`). |

#### Identities

| Field | Description |
| - | - |
| **Email** | Email address of the user who registered the WARP client where traffic originated from. |
| **User ID** | UUID of the user. Each unique email address in your organization will have a UUID associated with it. |
| **Registration ID** | UUID of the user's WARP client registration. A unique registration ID is generated each time a device is registered for a particular email. The same physical device may have multiple registration IDs. |
| **Device name** | Display name of the device returned by the operating system to the WARP client. Typically this is the hostname of a device. Not all devices will have a device name. Device names are not guaranteed to be unique. |
| **Device ID** | UUID of the device connected with the WARP client. Each physical device in your organization will have a UUID. |
| **Last authenticated** | Date and time the user last authenticated their Zero Trust session. |

#### DNS query details

| Field | Description |
| - | - |
| **Query ID** | UUID of the query assigned by Cloudflare. |
| **Query type** | Type of [DNS query](https://en.wikipedia.org/wiki/List_of_DNS_record_types). |
| **Initial query domain categories** | [Content categories](https://developers.cloudflare.com/cloudflare-one/traffic-policies/domain-categories/) that the domain belongs to. |
| **Matched categories** | Name of the Gateway policy category that match the domain. |
| **Matched indicator feed names** | Name of the indicator feeds that matched a Gateway policy. |
| **Query indicator feed names** | Name of the indicator feeds that a matched domain or IP belongs to. |
| **Resolved continent IP geolocation** | Continent code of the resolved IP address. |
| **Resolved country IP geolocation** | Country code of the resolved IP address. |
| **DoT subdomain** | DoT subdomain of the DNS location. |
| **Source IP** | Public source IP address of the DNS query. |
| **Source IP continent** | Continent code of the source IP address. |
| **Source IP country** | Country code of the source IP address. |
| **Source internal IP** | Private IP address assigned by the user's local network. |
| **Application name** | Name of the application that matched the domain. |
| **Resolver IP** | Public IP address of the DNS resolver. |
| **Port** | Port that was used to make the DNS query. |
| **Location ID** | ID of the DNS location where the query originated. |
| **Scheduling - Time zone** | Time zone of the DNS query source. |
| **Scheduling - Time zone inferred method** | Method used to determine the DNS query source's time zone. |

#### DNS response details

| Field | Description |
| - | - |
| **Resolved CNAME categories** | Content categories associated with the resolved `CNAME` records in the response. |
| **Resolved IP categories** | Content categories associated with the resolved IPs in the response. |
| **Resolved IPs** | Resolved IPs in the response. |
| **Authoritative nameserver IP** | IP address of the authoritative nameserver answering the DNS query. |
| **EDE errors** | [Extended DNS error codes](https://www.rfc-editor.org/rfc/rfc8914.html) in the response. |

#### Custom resolver

| Field | Description |
| - | - |
| **Address** | Address of your custom resolver. |
| **Policy** | Name of the matched resolver policy. |
| **Response** | Status of the custom resolver response. |
| **Time (in milliseconds)** | Duration of time it took for the custom resolver to respond. |

### Resolver decisions

| Name | Value | Description |
| - | - | - |
| `blockedByCategory` | `3` | Domain or hostname matched a category in a Block policy. |
| `allowedOnNoLocation` | `4` | Allowed because query did not match a Gateway DNS location. |
| `allowedOnNoPolicyMatch` | `5` | Allowed because query did not match a policy. |
| `blockedAlwaysCategory` | `6` | Domain or hostname is always blocked by Cloudflare. |
| `overrideForSafeSearch` | `7` | Response was overridden by a Safe Search policy. |
| `overrideApplied` | `8` | Response was overridden by an Override policy. |
| `blockedRule` | `9` | IP address in the response matched a Block policy. |
| `allowedRule` | `10` | IP address in the response matched an Allow policy. |

## Network logs

Failed connection logs

Gateway will only log TCP traffic with completed connections. If a connection is not complete (such as a TCP SYN with no SYN ACK), Gateway will not log this traffic in network logs.

Gateway can log failed connections in [network session logs](https://developers.cloudflare.com/logs/logpush/logpush-job/datasets/account/zero_trust_network_sessions/). These logs are available for Enterprise users via [Logpush](https://developers.cloudflare.com/cloudflare-one/insights/logs/logpush/) or [GraphQL](https://developers.cloudflare.com/cloudflare-one/insights/analytics/gateway/#graphql-queries).

### Explanation of the fields

#### Basic information

| Field | Description |
| - | - |
| **Source IP** | IP address of the user sending the packet. |
| **Source Internal IP** | Private IP address assigned by the user's local network. |
| **Destination IP** | IP address of the packet's target. |
| **Action** | The Gateway [Action](https://developers.cloudflare.com/cloudflare-one/traffic-policies/dns-policies/#actions) taken based on the first rule that matched (such as Allow or Block). |
| **Session ID** | ID of the unique session. |
| **Time** | Date and time of the session. |

#### Matched policies

| Field | Description |
| - | - |
| **DNS location** | [User-configured location](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/agentless/dns/locations/) from where the DNS query was made. |
| **Policy name** | Name of the matched policy. |
| **Policy ID** | ID of the policy enforcing the decision Gateway made. |
| **Policy description** | Description of the matched policy. |

#### Identities

| Field | Description |
| - | - |
| **Email** | Email address of the user sending the packet. This is generated by the WARP client. |
| **User ID** | ID of the user sending the packet. This is generated by the WARP client. |
| **Registration ID** | ID of the user's device registration. This is generated by the WARP client. |
| **Device name** | Name of the device that sent the packet. |
| **Device ID** | ID of the physical device that sent the packet. This is generated by the WARP client. |
| **Last authenticated** | Date and time the user last authenticated with Zero Trust. |

#### Network query details

| Field | Description |
| - | - |
| **Source IP** | IP address of the user sending the packet. |
| **Source port** | Source port number for the packet. |
| **Source country** | Country code for the packet source. |
| **Source IP continent** | Continent code of the source IP address. |
| **Source IP country** | Country code of the source IP address. |
| **Destination IP** | IP address of the packet's target. |
| **Destination port** | Destination port number for the packet. |
| **Destination IP continent** | Continent code of the IP address for the packet's destination. |
| **Destination IP country** | Country code of the IP address for the packet's destination. |
| **Transport protocol** | Protocol over which the packet was sent. |
| **Detected Protocol** | The detected [network protocol](https://developers.cloudflare.com/cloudflare-one/traffic-policies/network-policies/protocol-detection/). |
| **SNI** | Host whose Server Name Indication (SNI) header Gateway will filter traffic against. |
| **Virtual Network** | [Virtual network](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/private-net/cloudflared/tunnel-virtual-networks/) that the client is connected to. |
| **Category details** | Category or categories associated with the packet. |
| **Proxy endpoint** | [PAC file proxy endpoint](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/agentless/pac-files/) Gateway forwarded traffic to, if applicable. |
| **Application ID** | ID of the application that matched the domain. |
| **Application name** | Name of the application that matched the domain. |

## HTTP logs

Note

When an HTTP request results in an error, Gateway logs the first 512 bytes of the request for 30 days for internal troubleshooting. Otherwise, Gateway does not log HTTP bodies.

### Explanation of the fields

#### Basic information

| Field | Description |
| - | - |
| **Host** | Hostname in the HTTP header for the HTTP request. Gateway will log the SNI in this field if it responded to the request with a Do Not Inspect action. If Gateway does not receive the SNI, this field will be empty. |
| **Email** | Email address of the user who made the HTTP request. This is generated by the WARP client. |
| **Action** | The Gateway [Action](https://developers.cloudflare.com/cloudflare-one/traffic-policies/dns-policies/#actions) taken based on the first rule that matched (such as Allow or Block). |
| **Request ID** | Unique ID of the request. |
| **Time** | Date and time of the HTTP request. |
| **Source internal IP** | Private IP address assigned by the user's local network. |
| **User agent** | User agent header sent in the request by the originating device. |
| **Policy details** | Policy corresponding to the decision Gateway made based on the traffic criteria of the request. |
| **DLP profiles** | Name of the matched [DLP profile](https://developers.cloudflare.com/cloudflare-one/data-loss-prevention/dlp-profiles/). |
| **DLP profile entries** | Name of the matched entry within the DLP profile. |
| **Uploaded/downloaded file** | Information about the file transferred in the request found by [enhanced file detection](#enhanced-file-detection). Details include:- File name
- File type
- File size
- File hash (for Allowed requests only)
- Content type
- Direction (Upload/Download)
- Action (Block/Allow) |

#### Matched policies

| Field | Description |
| - | - |
| **DNS location** | [User-configured location](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/agentless/dns/locations/) from where the DNS query was made. |
| **Policy name** | Name of the matched policy. |
| **Policy ID** | ID of the matched policy. |
| **Policy description** | Description of the matched policy. |
| **Matched category ID** | ID of the category matched in the policy. |
| **Matched category name** | Name of the category matched in the policy. |

#### Identities

| Field | Description |
| - | - |
| **Email** | Email address of the user who made the HTTP request. This is generated by the WARP client. |
| **User ID** | ID of the user who made the request. This is generated by the WARP client. |
| **Registration ID** | ID of the user's device registration. This is generated by the WARP client. |
| **Device name** | Name of the device that made the request. |
| **Device ID** | ID of the physical device that made the request. This is generated by the WARP client on the device that created the request. |
| **Last authenticated** | Date and time the user last authenticated with Zero Trust. |

#### HTTP query details

| Field | Description |
| - | - |
| **HTTP Version** | HTTP version of the origin that Gateway connected to on behalf of the user. |
| **HTTP Method** | HTTP method used for the request (such as `GET` or `POST`). |
| **HTTP Status Code** | [HTTP status code](https://developers.cloudflare.com/support/troubleshooting/http-status-codes/) returned in the response. |
| **URL** | Full URL of the HTTP request. |
| **Referer** | Referer request header containing the address of the page making the request. |
| **Source IP** | Public source IP address of the HTTP request. |
| **Source Port** | Port that was used to make the HTTP request. |
| **Source IP continent** | Continent code of the HTTP request. |
| **Source IP country** | Country code of the HTTP request. |
| **Destination IP** | Public IP address of the destination requested. |
| **Destination Port** | Port of the destination requested. |
| **Destination IP continent** | Continent code of the destination requested. |
| **Destination IP country** | Country code of the destination requested. |
| **Blocked file reason** | Reason why the file was blocked if a file transfer occurred or was attempted. |
| **Category details** | Detailed information on the category the blocked file belongs to. |
| **Application ID** | ID of the application that matched the domain. |
| **Application name** | Name of the application that matched the domain. |
| **Categories** | [Content categories](https://developers.cloudflare.com/cloudflare-one/traffic-policies/domain-categories/) that the domain belongs to. |
| **Proxy endpoint** | [PAC file proxy endpoint](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/agentless/pac-files/) Gateway forwarded traffic to, if applicable. |
| **Virtual Network** | [Virtual network](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/private-net/cloudflared/tunnel-virtual-networks/) that the client is connected to. |
| **Sandbox scanned** | Status of the [file quarantine](https://developers.cloudflare.com/cloudflare-one/traffic-policies/http-policies/file-sandboxing/). |

#### File detection details

| Field | Description |
| - | - |
| **Name** | Name of the detected file. |
| **Type** | File type of the detected file. |
| **Size** | Size of the detected file. |
| **Hash** | Hash of the detected file, generated by DLP. |
| **Content type** | MIME type of the detected file. |
| **Direction** | Upload or download direction of the detected file. |
| **Action** | The Action Gateway applied to the request. |

### Enhanced file detection

Enhanced file detection is an optional feature to extract more file information from HTTP traffic. When turned on, Gateway will read file information from the HTTP body rather than the HTTP headers to provide greater accuracy and reliability. This feature may have a minor impact on performance for file-heavy organizations.

To turn on enhanced file detection:

1. In [Zero Trust](https://one.dash.cloudflare.com/), go to **Settings** > **Network**.
2. In **Firewall**, turn on **TLS decryption**.
3. In **Gateway Logging**, turn on **Enable enhanced file detection**.

### Isolate requests

When a user creates an [isolation policy](https://developers.cloudflare.com/cloudflare-one/remote-browser-isolation/isolation-policies/), Gateway logs the initial request that triggers isolation as an Isolate action. Because this request is not isolated yet, the `is_isolated` field will return `false`. Zero Trust then securely returns the result to the user in an isolated browser. Gateway will log all subsequent requests in the isolated browser with the action (such as Allow or Block), and the `is_isolated` field will return `true`.

## Limitations

If a connection closes before Gateway inspects and filters the traffic, Gateway will log the traffic with an Unknown action.

Gateway activity logs are not available in the dashboard if you turn on the [Customer Metadata Boundary (CMB)](https://developers.cloudflare.com/data-localization/metadata-boundary/) within Cloudflare Data Localization Suite (DLS). Enterprise users using CMB can still export logs via [Logpush](https://developers.cloudflare.com/cloudflare-one/insights/logs/logpush/). For more information, refer to [DLS product compatibility](https://developers.cloudflare.com/data-localization/compatibility/#zero-trust).
