---
title: Improved support for Node.js Crypto and TLS APIs in Workers · Changelog
description: Node.js APIs from the node:crypto and node:tls modules are now
  available when using nodejs_compat.
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/changelog/2025-04-08-nodejs-crypto-and-tls/
  md: https://developers.cloudflare.com/changelog/2025-04-08-nodejs-crypto-and-tls/index.md
---

# Changelog

New updates and improvements at Cloudflare.

[Subscribe to RSS](https://developers.cloudflare.com/changelog/rss/index.xml)\
[View all RSS feeds](https://developers.cloudflare.com/fundamentals/new-features/available-rss-feeds/)

![hero image](https://developers.cloudflare.com/_astro/hero.CVYJHPAd_ZEA2nF.svg)

[← Back to all posts](https://developers.cloudflare.com/changelog/)

## Improved support for Node.js Crypto and TLS APIs in Workers

Apr 08, 2025

[Workers](https://developers.cloudflare.com/workers/)

When using a Worker with the [`nodejs_compat`](https://developers.cloudflare.com/workers/runtime-apis/nodejs/) compatibility flag enabled, the following Node.js APIs are now available:

* [`node:crypto`](https://developers.cloudflare.com/workers/runtime-apis/nodejs/crypto/)
* [`node:tls`](https://developers.cloudflare.com/workers/runtime-apis/nodejs/tls/)

This make it easier to reuse existing Node.js code in Workers or use npm packages that depend on these APIs.

#### node:crypto

The full [`node:crypto`](https://nodejs.org/api/crypto.html) API is now available in Workers.

You can use it to verify and sign data:

```js
import { sign, verify } from "node:crypto";


const signature = sign("sha256", "-data to sign-", env.PRIVATE_KEY);
const verified = verify("sha256", "-data to sign-", env.PUBLIC_KEY, signature);
```

Or, to encrypt and decrypt data:

```js
import { publicEncrypt, privateDecrypt } from "node:crypto";


const encrypted = publicEncrypt(env.PUBLIC_KEY, "some data");
const plaintext = privateDecrypt(env.PRIVATE_KEY, encrypted);
```

See the [`node:crypto` documentation](https://developers.cloudflare.com/workers/runtime-apis/nodejs/crypto/) for more information.

#### node:tls

The following APIs from `node:tls` are now available:

* [`connect`](https://nodejs.org/api/tls.html#tlsconnectoptions-callback)
* [`TLSSocket`](https://nodejs.org/api/tls.html#class-tlstlssocket)
* [`checkServerIdentity`](https://nodejs.org/api/tls.html#tlscheckserveridentityhostname-cert)
* [`createSecureContext`](https://nodejs.org/api/tls.html#tlscreatesecurecontextoptions)

This enables secure connections over TLS (Transport Layer Security) to external services.

```js
import { connect } from "node:tls";


// ... in a request handler ...
const connectionOptions = { key: env.KEY, cert: env.CERT };
const socket = connect(url, connectionOptions, () => {
  if (socket.authorized) {
    console.log("Connection authorized");
  }
});


socket.on("data", (data) => {
  console.log(data);
});


socket.on("end", () => {
  console.log("server ends connection");
});
```

See the [`node:tls` documentation](https://developers.cloudflare.com/workers/runtime-apis/nodejs/tls/) for more information.
