---
title: ​Purge everything · Cloudflare Cache (CDN) docs
description: To maintain optimal site performance, Cloudflare strongly
  recommends using single-file (by URL) purging instead of a complete cache
  purge.
lastUpdated: 2025-10-06T13:41:54.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cache/how-to/purge-cache/purge-everything/
  md: https://developers.cloudflare.com/cache/how-to/purge-cache/purge-everything/index.md
---

To maintain optimal site performance, Cloudflare strongly recommends using single-file (by URL) purging instead of a complete cache purge.

Purging everything instantly clears all resources from your CDN cache in all Cloudflare data centers. Each new request for a purged resource returns to your origin server to validate the resource. If Cloudflare cannot validate the resource, Cloudflare fetches the latest version from the origin server and replaces the cached version. When a site with heavy traffic contains a lot of assets, requests to your origin server can increase substantially and result in slow site performance.

1. In the Cloudflare dashboard, go to the **Configuration** page.

   [Go to **Configuration**](https://dash.cloudflare.com/?to=/:account/:zone/caching/configuration)

2. Under **Purge Cache**, select **Purge Everything**. A warning window appears.

3. If you agree, select **Purge Everything**.

Note

When purging everything for a non-production cache environment, all files for that specific cache environment will be purged. However, when purging everything for the production environment, all files will be purged across all environments.

For information on rate limits, refer to the [Availability and limits](https://developers.cloudflare.com/cache/how-to/purge-cache/#availability-and-limits) section.

## Resulting cache status

Purge Everything invalidates the resource, resulting in the `CF-Cache-Status` header indicating [`EXPIRED`](https://developers.cloudflare.com/cache/concepts/cache-responses/#expired) for subsequent requests.
