---
title: Bot Management variables · Cloudflare bot solutions docs
description: Bot Management provides access to several new variables within the
  expression builder of Ruleset Engine-based products such as WAF custom rules.
lastUpdated: 2025-10-15T15:50:02.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/bots/reference/bot-management-variables/
  md: https://developers.cloudflare.com/bots/reference/bot-management-variables/index.md
---

## Ruleset Engine fields

Bot Management provides access to several [new variables](https://developers.cloudflare.com/ruleset-engine/rules-language/fields/reference/?field-category=Bots) within the expression builder of Ruleset Engine-based products such as [WAF custom rules](https://developers.cloudflare.com/waf/custom-rules/).

* **Bot Score** (`cf.bot_management.score`): An integer between 1-99 that indicates [Cloudflare's level of certainty](https://developers.cloudflare.com/bots/concepts/bot-score/) that a request comes from a bot.

* **Verified Bot** (`cf.bot_management.verified_bot`): A boolean value that indicates whether a request originates from a Cloudflare allowed bot.

  Cloudflare maintains a large allowlist of good, automated bots (such as Google Search Engine and Pingdom) that perform beneficial tasks. Cloudflare identifies and verifies these bots primarily through reverse DNS validation, ensuring the source IP matches the requesting service.

  We also use additional validation methods, including checking ASN blocks and public lists. If these methods are unavailable, Cloudflare utilizes internal data and machine learning to identify and verify legitimate IP addresses from good bots. Most customers choose to [allow this traffic](https://developers.cloudflare.com/ruleset-engine/rules-language/fields/reference/cf.bot_management.verified_bot/).

* **Serves Static Resource** (`cf.bot_management.static_resource`): An identifier that matches [file extensions](https://developers.cloudflare.com/bots/additional-configurations/static-resources/) for many types of static resources. Use this variable if you send emails that retrieve static images.

* **ja3Hash** (`cf.bot_management.ja3_hash`) and **ja4** (`cf.bot_management.ja4`): A [**JA3/JA4 fingerprint**](https://developers.cloudflare.com/bots/additional-configurations/ja3-ja4-fingerprint/) helps you profile specific SSL/TLS clients across different destination IPs, Ports, and X509 certificates.

* **Bot Detection IDs** (`cf.bot_management.detection_ids`): List of IDs that correlate to the Bot Management heuristic detections made on a request (you can have multiple heuristic detections on the same request).

* **Verified Bot Categories** (`cf.verified_bot_category`): A string that allows you to segment your verified bot traffic by its [type and purpose](https://developers.cloudflare.com/bots/concepts/bot/verified-bots/#categories).

## Workers variables

These variables are also available as part of the [request.cf](https://developers.cloudflare.com/workers/runtime-apis/request/#incomingrequestcfproperties) object via Cloudflare Workers:

* `request.cf.botManagement.score`
* `request.cf.botManagement.verifiedBot`
* `request.cf.botManagement.staticResource`
* `request.cf.botManagement.ja3Hash`
* `request.cf.botManagement.ja4`
* `request.cf.botManagement.jsDetection.passed`
* `request.cf.botManagement.detectionIds`
* `request.cf.verifiedBotCategory`

## Corporate Proxy

The Bot Management Corporate Proxy field contains identified cloud-based corporate proxies and secure web gateways that are Enterprise-only, and provide outbound security services to their clients.

You can access the Corporate Proxy field in [custom rules](https://developers.cloudflare.com/waf/custom-rules/), [rate limiting rules](https://developers.cloudflare.com/waf/rate-limiting-rules/), or [Workers](https://developers.cloudflare.com/workers/) to provide different security rules for traffic from these sources. You can also exempt them from rules using Bot Management scores.

```txt
not cf.bot_management.verified_bot
and not cf.bot_management.static_resource
and not  cf.bot_management.corporate_proxy
and cf.bot_management.score lt 30
```

## Log fields

Once you enable Bot Management, Cloudflare also surfaces bot information in its [HTTP requests log fields](https://developers.cloudflare.com/logs/logpush/logpush-job/datasets/zone/http_requests/):

* BotDetectionIDs
* BotScore
* BotScoreSrc
* BotTags
