---
title: Authentication Posture · Cloudflare API Shield docs
description: Authentication Posture helps users identify authentication
  misconfigurations for APIs and alerts of their presence.
lastUpdated: 2025-11-07T16:57:24.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/api-shield/security/authentication-posture/
  md: https://developers.cloudflare.com/api-shield/security/authentication-posture/index.md
---

Authentication Posture helps users identify authentication misconfigurations for APIs and alerts of their presence.

For example, a security team member may believe that their API hosted at `/api/v1/users` and `/api/v1/orders` are guarded by the fact that only authenticated users can interact with the endpoints. However, bugs in origin API authentication policies may lead to broken authentication vulnerabilities. Authentication Posture with API Shield details the authentication status of successful requests to your API endpoints, alerting to potential misconfigurations.

Consider a typical e-commerce application. Users can browse items and prices without being logged in. However, to retrieve order details with the `GET /api/v1/orders/{order_id}` endpoint, this example application requires users to log in to their account and pass the subsequent Authorization HTTP header in all requests. Cloudflare will alert via [Security Center Insights](https://developers.cloudflare.com/security-center/security-insights/) and [Endpoint labels](https://developers.cloudflare.com/api-shield/management-and-monitoring/endpoint-labels/) if successful requests are sent to the `GET /api/v1/orders/{order_id}` endpoint or any other endpoint without authentication when session identifiers are configured.

## Process

After configuring [session identifiers](https://developers.cloudflare.com/api-shield/get-started/#session-identifiers), API Shield continuously scans your traffic for successful requests without authentication and labels your endpoints on a daily basis. Refer to the table below for our labeling methodology.

| Description | 2xx response codes | 4xx, 5xx response codes |
| - | - | - |
| If all requests are missing authentication, Cloudflare will apply the label: | `cf-missing-auth` | Without successful responses, no label will be added. |
| If only some requests are missing authentication, Cloudflare will apply the label: | `cf-mixed-auth` | Without successful responses, no label will be added. |

### Examine an endpoint's authentication details

* Old dashboard

  1. Log in to the [Cloudflare dashboard](https://dash.cloudflare.com/), and select your account and domain.
  2. Go to **Security** > **API Shield** > **Endpoint Management**.
  3. Filter Endpoint Management by the `cf-risk-missing-auth` or `cf-risk-mixed-auth` labels.
  4. Select an endpoint to see its authentication posture details on the endpoint details page.
  5. Choose between the 24-hour and 7-day view options, and note any authentication changes over time.

* New dashboard

  1. In the Cloudflare dashboard, go to the **Web Assets** page.

     [Go to **Web assets**](https://dash.cloudflare.com/?to=/:account/:zone/security/web-assets)

  2. Go to the **Endpoints** tab.

  3. Filter your endpoints by the `cf-risk-missing-auth` or `cf-risk-mixed-auth` labels.

  4. Select an endpoint to see its authentication posture details on the endpoint details page.

  5. Choose between the 24-hour and 7-day view options, and note any authentication changes over time.

The main authentication widget displays how many successful requests over the last seven days had session identifiers included with them, and which identifiers were included with the traffic.

The authentication-over-time chart shows a detailed breakdown over time of how clients successfully interacted with your API and which identifiers were used. A large increase in unauthenticated traffic may signal a security incident. Similarly, any successful unauthenticated traffic on an endpoint that is expected to be 100% authenticated can be a cause for concern.

Work with your development team to understand which authentication policies may need to be corrected on your API to stop unauthenticated traffic.

### Stop unauthenticated traffic with Cloudflare

You can use the `cf.api_gateway.auth_id_present` field in [custom rules](https://developers.cloudflare.com/waf/custom-rules/) to trigger when the API Shield configured session identifiers are present or absent on a request. Since this rule would cover your entire zone, Cloudflare recommends adding a host and path match in the rule to pinpoint the protection to exactly what is needed.

## Limitations

Authentication Posture can only apply when customers accurately set up session identifiers in API Shield. As a reminder, session identifiers are meant to uniquely identify authenticated users of your API. If you are unsure of your API's session identifier, consult with your development team.

## Availability

Authentication Posture is available for all Enterprise customers with an API Shield subscription.
